namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'business_name',
        'business_address_line1',
        'business_address_line2',
        'city',
        'state',
        'zip_code',
        'country',
        'phone_number',
        'incorporation_details',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}